/*!
 *
 * 4DView Pro library 0.0.0
 *
 * Copyright(c) 4D SAS.  All rights reserved.
 *
 * 4D (the "Software") and the corresponding source code remain
 * the exclusive property of 4D and/or its licensors and are protected by national
 * and/or international legislations.
 *
 * This file is part of the source code of the Software provided under the relevant
 * 4D License Agreement available on http://www.4D.com/license whose compliance
 * constitutes a prerequisite to any use of this file and more generally of the
 * Software and the corresponding source code.
 *
 */

(function () {
    Utils.addCommand('show-cell', function (params) {
        if (('ranges' in params) && (params.ranges.constructor === Array)) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                instance.sheet.showCell(instance.row, instance.column, params.verticalPosition, params.horizontalPosition);
            }
        }
    });

    Utils.addCommand('get-selection', function (params) {
        const sheet = Utils.resolveSheet(params.sheetIndex);
        if (sheet != null) {
            const sheetIndex = Utils.spread.getSheetIndex(sheet.name());
            const selection = sheet.getSelections();
            const ret = { 'ranges': [] };
            selection.forEach(i => {
                const range = { 'sheet': sheetIndex };

                if (i.row != -1) {
                    range.row = i.row;
                    range.rowCount = i.rowCount;
                }

                if (i.col != -1) {
                    range.column = i.col;
                    range.columnCount = i.colCount;
                }

                ret.ranges.push(range);
            });
            return ret;
        } else {
            return null;
        }
    });

    Utils.addCommand('get-active-cell', function (params) {
        const sheet = Utils.resolveSheet(params.sheetIndex);
        if (sheet != null) {
            const sheetIndex = Utils.spread.getSheetIndex(sheet.name());
            return {
                'row': sheet.getActiveRowIndex(),
                'column': Utils.currentSheet.getActiveColumnIndex(),
                'sheetIndex': sheetIndex
            };
        } else {
            return null;
        }
    });

    Utils.addCommand('set-active-cell', function (params) {
        if (('ranges' in params) && (params.ranges.constructor === Array)) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                instance.sheet.setActiveCell(instance.row, instance.column);
                Utils.needToUpdateFormulaBar = true;
            }
        }
    });

    function setSelection(params, addOnly) {
        if (('ranges' in params) && (params.ranges.constructor === Array)) {

            const selCleared = [];

            params.ranges.forEach(range => {
                const instancesArray = [];

                Utils.getRanges(range, instancesArray);

                instancesArray.forEach(i => {
                    const sheetIndex = Utils.spread.getSheetIndex(i.sheet.name());

                    if (i.type == "rows") {
                        i.column = -1;
                        i.columnCount = -1;
                    }

                    if (i.type == "columns") {
                        i.row = -1;
                        i.rowCount = -1;
                    }

                    if (addOnly || selCleared[sheetIndex] === 'cleared') {
                        i.sheet.addSelection(i.row, i.column, i.rowCount, i.columnCount);
                    } else {
                        i.sheet.setSelection(i.row, i.column, i.rowCount, i.columnCount);
                        selCleared[sheetIndex] = 'cleared';
                    }
                });
            });
        }
    }

    Utils.addCommand('set-selection', function (params) {
        setSelection(params, false);
        Utils.needToUpdateFormulaBar = true;
    });

    Utils.addCommand('add-selection', function (params) {
        setSelection(params, true);
        Utils.needToUpdateFormulaBar = true;
    });

    Utils.addCommand('reset-selection', function (params) {
        const sheet = Utils.resolveSheet(params.sheetIndex);
        if (sheet != null) {
            sheet.clearSelection();
            Utils.needToUpdateFormulaBar = true;
        }
    });

    Utils.convertValuesFrom4D = function(value) {
        let ret = null;

        if ((typeof (value) == 'number')
            || (typeof (value) == 'string')
            || (typeof (value) == 'boolean')
            || (value === null)) {
            ret = { 'value': value };
        }
        else if (typeof (value) == 'object') {

            const hasDay = ('day' in value) && (typeof (value.day) === 'number');
            const hasMonth = ('month' in value) && (typeof (value.month) === 'number');
            const hasYear = ('year' in value) && (typeof (value.year) === 'number');

            const hasSeconds = ('seconds' in value) && (typeof (value.seconds) === 'number');
            const hasMinutes = ('minutes' in value) && (typeof (value.minutes) === 'number');
            const hasHours = ('hours' in value) && (typeof (value.hours) === 'number');

            if (!hasDay && !hasMonth && !hasYear && !hasSeconds && !hasMinutes && !hasHours) {
                ret = value;
            } else if (hasDay && hasMonth && hasYear && !hasSeconds && !hasMinutes && !hasHours) {
                if (value.year != 0 || value.month != 0 || value.day != 0) {
                    ret = {
                        'value': new Date(value.year, value.month - 1, value.day)
                     };
                }
            } else if (!hasDay && !hasMonth && !hasYear && hasSeconds && hasMinutes && hasHours) {
                ret = { 'value': new Date(1899, 11, 30, value.hours, value.minutes, value.seconds) };
            } else if (hasDay && hasMonth && hasYear && hasSeconds && hasMinutes && hasHours) {
                if (value.year != 0 || value.month != 0 || value.day != 0) {
                    ret = {
                        'value': new Date(value.year, value.month - 1, value.day,
                            value.hours, value.minutes, value.seconds)
                    };
                } else if ((value.hours != 0) || (value.minutes != 0) || (value.seconds != 0)) {
                    ret = {
                        'value': new Date(1899, 11, 30,
                            value.hours, value.minutes, value.seconds)
                    };
                }
            }
        }
        return ret;
    };

    Utils.addCommand('set-ranges-value', function (params) {

        if ('value' in params) {

            const val = Utils.convertValuesFrom4D(params.value);

            if (val != null) {

                let format = null;
                if (('format' in params) && (typeof (params.format) === 'string'))
                    format = Utils.adjustFormat(params.format);

                if (('ranges' in params) && (params.ranges.constructor === Array)) {

                    params.ranges.forEach(range => {
                        const instancesArray = [];

                        Utils.getRanges(range, instancesArray);

                        instancesArray.forEach(i => {

                            const instance = i.sheet.getRange(i.row, i.column, i.rowCount, i.columnCount);

                            instance.formula(null);
                            instance.value(val.value);

                            if (format != null)
                                instance.formatter(format);
                        });
                    });

                    Utils.needToUpdateFormulaBar = true;
                }
            }
        }
    });

    Utils.addCommand('set-values', function (params) {

        if (('value' in params) && (params.value.constructor === Array)) {

            const ar = params.value;

            if (ar.length > 0) {

                ar.forEach(function (row, rowIndex) {
                    if ((row != null) && (row.constructor === Array)) {
                        row.forEach(function (content, colIndex) {
                            const val = Utils.convertValuesFrom4D(content);
                            if (val != null) {
                                ar[rowIndex][colIndex] = val.value;
                            } else {
                                ar[rowIndex][colIndex] = undefined;
                            }
                        });
                    } else {
                        ar[rowIndex] = null;
                    }
                });

                if ('ranges' in params) {
                    const instance = Utils.getFirstRange(params.ranges);
                    if (instance != null) {
                        instance.sheet.setArray(instance.row, instance.column, ar);
                    }
                }
            }
        }
        Utils.needToUpdateFormulaBar = true;
    });

    Utils.addCommand('set-formulas', function (params) {

        if (('value' in params) && (params.value.constructor === Array)) {

            const ar = params.value;

            if (ar.length > 0) {

                ar.forEach(function (row, rowIndex) {
                    if ((row != null) && (row.constructor === Array)) {
                        row.forEach(function (content, colIndex) {
                            if (!(typeof (content) === 'string')) {
                                ar[rowIndex][colIndex] = null;
                            }
                        });
                    } else {
                        ar[rowIndex] = null;
                    }
                });

                if ('ranges' in params) {
                    const instance = Utils.getFirstRange(params.ranges);
                    if (instance != null) {
                        instance.sheet.setArray(instance.row, instance.column, ar, true);
                    }
                }
            }
        }
        Utils.needToUpdateFormulaBar = true;
    });

    Utils.convertValueTo4D = function(value, dateKey = "date") {
		if (value === null) return null;
		if (value.constructor === Date) {
			ret = {};

			const day = value.getDate();
			const month = value.getMonth();
			const year = value.getFullYear();

			ret[dateKey] = { 'day': day, 'month': month + 1, 'year': year };

			const hours = value.getHours();
			const minutes = value.getMinutes();
			const seconds = value.getSeconds();

			ret.time = (hours * 3600) + (minutes * 60) + seconds;

			ret.$4d_convertToDate = true;

			return ret;
		}
		else if (typeof(value) === "object") {
			return Utils._transformObjectDateValues(value);
		}
		return value;
    };

    Utils._transformObjectDateValues = function (objectValue) {
        if (objectValue === null) return null;

        for (const property in objectValue) {
            const child = objectValue[property];
            if (child != null) {
                if (child.constructor === Date) {
                    objectValue[property] = Utils.convertValueTo4D(child);
                }
                else if (typeof(child) === "object") {
                    objectValue[property] = Utils._transformObjectDateValues(child);
                }
            }
        }

        return objectValue;
    };

    Utils.addCommand('get-value', function (params) {

        const ret = { 'value': null };

        if ('ranges' in params) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                ret.value = Utils.convertValueTo4D(instance.sheet.getCell(instance.row, instance.column).value());
            }
        }

        return ret;
    });

    Utils.addCommand('get-values', function (params) {

        const ret = { 'value': [[]] };

        if ('ranges' in params) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                const ar = instance.sheet.getArray(instance.row, instance.column, instance.rowCount, instance.columnCount);

                ar.forEach(function (row, rowIndex) {
                    row.forEach(function (content, colIndex) {
                        if ((content != null) && (content.constructor === Date)) {
                            ar[rowIndex][colIndex] = Utils.convertValueTo4D(content);
                        }
                    });
                });

                ret.value = ar;
            }
        }

        return ret;
    });

    Utils.addCommand('get-formulas', function (params) {

        const ret = { 'value': [[]] };

        if ('ranges' in params) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                const ar = instance.sheet.getArray(instance.row, instance.column, instance.rowCount, instance.columnCount, true);

                ar.forEach(function (row, rowIndex) {
                    row.forEach(function (col, colIndex) {
                        if (col === null)
                            ar[rowIndex][colIndex] = '';
                    });
                });

                ret.value = ar;
            }
        }

        return ret;
    });

    Utils.addCommand('set-ranges-formula', function (params) {

        if ((('formula' in params) && (typeof (params.formula) == 'string'))
            && ('ranges' in params) && (params.ranges.constructor === Array)) {

            let format = null;
            if (('format' in params) && (typeof (params.format) === 'string'))
                format = Utils.adjustFormat(params.format);

            params.ranges.forEach(range => {
                const instancesArray = [];

                Utils.getRanges(range, instancesArray);

                instancesArray.forEach(i => {
                    const instance = i.sheet.getRange(i.row, i.column, i.rowCount, i.columnCount);
                    try {
                        instance.formula(params.formula);
                    }
                    catch(e) {
                        Utils.logEvent({ type: 'error-catched', data: e, formula: params.formula});
                        if (Utils.spread.options.allowInvalidFormula == true) {
                            instance.formula(null);
                            instance.value("=" + params.formula);
                        }
                    }
                });
            });

            Utils.needToUpdateFormulaBar = true;
        }
    });

    Utils.addCommand('get-formula', function (params) {

        const ret = { 'value': '' };

        if ('ranges' in params) {
            const instance = Utils.getFirstRange(params.ranges);
            if (instance != null) {
                ret.value = instance.sheet.getCell(instance.row, instance.column).formula();
            }
            if (ret.value === null)
                ret.value = '';
        }

        return ret;
    });

})();